<div class="container-fluid">
	<%= _.template($('#input_constructor').html())({
		id: "email",
		description: tr("Email"),
		default_selector: "string",
		disable_int: true,
		value_string: "",
		help: {
			description: tr("Email which was purchased from our service."),
		}
	}) %>
	<%= _.template($('#input_constructor').html())({
		id: "password",
		description: tr("Password"),
		default_selector: "string",
		disable_int: true,
		value_string: "",
		help: {
			description: tr("The password to the purchased email."),
		}
	}) %>
	<%= _.template($('#block_start').html())({
		id:"Options",
		name: tr("Options"),
		description: tr("All fields of this group are optional")
	}) %>
		<%= _.template($('#input_constructor').html())({
			id: "search",
			description: tr("Search"),
			default_selector: "string",
			disable_int: true,
			value_string: "",
			help: {
				description: tr("Search by email content, header, and sender."),
			}
		}) %>
		<%= _.template($('#input_constructor').html())({
			id: "star",
			description: tr("Star"),
			default_selector: "string",
			disable_int: true,
			value_string: "",
			variants: [
				"true",
				"false",
			],
			help: {
				description: tr("Get emails that are or are not in your favorites."),
			}
		}) %>
	<%= _.template($('#block_end').html())() %>
	<%= _.template($('#block_start').html())({
		id:"Requests",
		name: tr("Requests delivery"),
		description: tr("It is recommended to leave the default settings, or increase them if you have a slow Internet connection")
	}) %>
		<%= _.template($('#input_constructor').html())({
			id: "timeout",
			description: tr("Timeout"),
			default_selector: "int",
			disable_string: true,
			value_number: 5,
			min_number:	1,
			max_number:	60,
			help: {
				description: tr("Maximum waiting time per request."),
				examples: [
					{code: 1, description: tr("Wait 1 second.")},
					{code: 5, description: tr("Wait 5 seconds.")},
					{code: 10, description: tr("Wait 10 seconds.")}
				]
			}
		}) %>
		<%= _.template($('#input_constructor').html())({
			id: "interval",
			description: tr("Interval"),
			default_selector: "int",
			disable_string: true,
			value_number: 3,
			min_number: 1,
			max_number:	1200,
			help: {
				description: tr("Interval for sending requests."),
				examples: [
					{code: 1, description: tr("Send request every second.")},
					{code: 5, description: tr("Send request every 5 seconds.")},
					{code: 10, description: tr("Send request every 10 seconds.")}
				]
			}
		}) %>
		<%= _.template($('#input_constructor').html())({
			id: "maxTime",
			description: tr("Time threshold"),
			default_selector: "int",
			disable_string: true,
			value_number: 10,
			min_number: 1,
			max_number:	1000000,
			help: {
				description: tr("Maximum execution time."),
				examples: [
					{code: 1, description: tr("Perform an action no more than 1 second.")},
					{code: 5, description: tr("Perform an action no more than 5 seconds.")},
					{code: 10, description: tr("Perform an action no more than 10 seconds.")}
				]
			}
		}) %>
	<%= _.template($('#block_end').html())() %>
	<%= _.template($('#variable_constructor').html())({
		id: "Save1",
		description: tr("Variable to save the list of e-mails"),
		default_variable: "NOTLETTERS_LETTERS",
	}) %>
	<%= _.template($('#variable_constructor').html())({
		id: "Save2",
		description: tr("Variable to save the result"),
		default_variable: "NOTLETTERS_RESPONSE",
	}) %>
</div>
<div class="tooltipinternal">
	<div class="tr tooltip-paragraph-first-fold">Receiving letters from the mail.</div>
	<div class="tr tooltip-paragraph-first-fold">Filters are optional fields, in the search field you can specify a query to search for emails.</div>
	<div class="tr tooltip-paragraph-first-fold">Search by email content, header, and sender.</div>
</div>
<%= _.template($('#back').html())({action:"executeandadd", visible:true}) %>
<%= "<s" + "cript>" %>
		$(document).ready(function(){
			let nlOkButton = document.getElementById('ok')
			nlOkButton.style.backgroundColor = '#fbad46'
			nlOkButton.style.borderColor = '#352b1e'
			let nlVariables = document.querySelectorAll(".variable-input");
			for (let i = 0; i < nlVariables.length; i++) {
				nlVariables[i].style.color = "#fbad46";
			}
			});
<%= "</" + "script>" %>
