<div class="container-fluid">
	<%= _.template($('#block_start').html())({
		id:"Requests",
		name: tr("Requests delivery"),
		description: tr("It is recommended to leave the default settings, or increase them if you have a slow Internet connection")
	}) %>
		<%= _.template($('#input_constructor').html())({
			id: "timeout",
			description: tr("Timeout"),
			default_selector: "int",
			disable_string: true,
			value_number: 5,
			min_number:	1,
			max_number:	60,
			help: {
				description: tr("Maximum waiting time per request."),
				examples: [
					{code: 1, description: tr("Wait 1 second.")},
					{code: 5, description: tr("Wait 5 seconds.")},
					{code: 10, description: tr("Wait 10 seconds.")}
				]
			}
		}) %>
		<%= _.template($('#input_constructor').html())({
			id: "interval",
			description: tr("Interval"),
			default_selector: "int",
			disable_string: true,
			value_number: 3,
			min_number: 1,
			max_number:	1200,
			help: {
				description: tr("Interval for sending requests."),
				examples: [
					{code: 1, description: tr("Send request every second.")},
					{code: 5, description: tr("Send request every 5 seconds.")},
					{code: 10, description: tr("Send request every 10 seconds.")}
				]
			}
		}) %>
		<%= _.template($('#input_constructor').html())({
			id: "maxTime",
			description: tr("Time threshold"),
			default_selector: "int",
			disable_string: true,
			value_number: 10,
			min_number: 1,
			max_number:	1000000,
			help: {
				description: tr("Maximum execution time."),
				examples: [
					{code: 1, description: tr("Perform an action no more than 1 second.")},
					{code: 5, description: tr("Perform an action no more than 5 seconds.")},
					{code: 10, description: tr("Perform an action no more than 10 seconds.")}
				]
			}
		}) %>
	<%= _.template($('#block_end').html())() %>
	<%= _.template($('#variable_constructor').html())({
		id: "Save1",
		description: tr("Variable to save the account id"),
		default_variable: "NOTLETTERS_ID",
	}) %>
	<%= _.template($('#variable_constructor').html())({
		id: "Save2",
		description: tr("Variable to save account username"),
		default_variable: "NOTLETTERS_USERNAME",
	}) %>
	<%= _.template($('#variable_constructor').html())({
		id: "Save3",
		description: tr("Variable to save account balance"),
		default_variable: "NOTLETTERS_BALANCE",
	}) %>
	<%= _.template($('#variable_constructor').html())({
		id: "Save4",
		description: tr("Variable to save account rate limit"),
		default_variable: "NOTLETTERS_RATE_LIMIT",
	}) %>
	<%= _.template($('#variable_constructor').html())({
		id: "Save5",
		description: tr("Variable to save the result"),
		default_variable: "NOTLETTERS_RESPONSE",
	}) %>
</div>
<div class="tooltipinternal">
	<div class="tr tooltip-paragraph-first-fold">Get balance.</div>
</div>
<%= _.template($('#back').html())({action:"executeandadd", visible:true}) %>
<%= "<s" + "cript>" %>
		$(document).ready(function(){
			let nlOkButton = document.getElementById('ok')
			nlOkButton.style.backgroundColor = '#fbad46'
			nlOkButton.style.borderColor = '#352b1e'
			let nlVariables = document.querySelectorAll(".variable-input");
			for (let i = 0; i < nlVariables.length; i++) {
				nlVariables[i].style.color = "#fbad46";
			}
			});
<%= "</" + "script>" %>
