<div class="container-fluid">
	<%= _.template($('#input_constructor').html())({
		id: "count",
		description: tr("Count"),
		default_selector: "int",
		disable_string: true,
		value_number: 1,
        min_number: 1,
		help: {
			description: tr("How many email accounts to purchase."),
		}
	}) %>
	<%= _.template($('#input_constructor').html())({
		id: "type_email",
		description: tr("Email type"),
		default_selector: "int",
		disable_string: true,
		value_number: 0,
		variants: [
			"0<br/><span style='color:rgb(251, 173, 70)'>" + tr("Limited") + "</span>",
			"1<br/><span style='color:rgb(251, 173, 70)'>" + tr("Unlimited") + "</span>",
			"2<br/><span style='color:rgb(251, 173, 70)'>" + tr("RU zone") + "</span>",
			"3<br/><span style='color:rgb(251, 173, 70)'>" + tr("Personal") + "</span>"
		],
		help: {
			description: tr("Type of email accounts to be purchased."),
		}
	}) %>
	<%= _.template($('#block_start').html())({
		id:"Requests",
		name: tr("Requests delivery"),
		description: tr("It is recommended to leave the default settings, or increase them if you have a slow Internet connection")
	}) %>
		<%= _.template($('#input_constructor').html())({
			id: "timeout",
			description: tr("Timeout"),
			default_selector: "int",
			disable_string: true,
			value_number: 5,
			min_number:	1,
			max_number:	60,
			help: {
				description: tr("Maximum waiting time per request."),
				examples: [
					{code: 1, description: tr("Wait 1 second.")},
					{code: 5, description: tr("Wait 5 seconds.")},
					{code: 10, description: tr("Wait 10 seconds.")}
				]
			}
		}) %>
		<%= _.template($('#input_constructor').html())({
			id: "interval",
			description: tr("Interval"),
			default_selector: "int",
			disable_string: true,
			value_number: 3,
			min_number: 1,
			max_number:	1200,
			help: {
				description: tr("Interval for sending requests."),
				examples: [
					{code: 1, description: tr("Send request every second.")},
					{code: 5, description: tr("Send request every 5 seconds.")},
					{code: 10, description: tr("Send request every 10 seconds.")}
				]
			}
		}) %>
		<%= _.template($('#input_constructor').html())({
			id: "maxTime",
			description: tr("Time threshold"),
			default_selector: "int",
			disable_string: true,
			value_number: 10,
			min_number: 1,
			max_number:	1000000,
			help: {
				description: tr("Maximum execution time."),
				examples: [
					{code: 1, description: tr("Perform an action no more than 1 second.")},
					{code: 5, description: tr("Perform an action no more than 5 seconds.")},
					{code: 10, description: tr("Perform an action no more than 10 seconds.")}
				]
			}
		}) %>
	<%= _.template($('#block_end').html())() %>
	<%= _.template($('#variable_constructor').html())({
		id: "Save1",
		description: tr("Variable to save the email list"),
		default_variable: "NOTLETTERS_EMAILS",
	}) %>
	<%= _.template($('#variable_constructor').html())({
		id: "Save2",
		description: tr("Variable to save the result"),
		default_variable: "NOTLETTERS_RESPONSE",
	}) %>
</div>
<div class="tooltipinternal">
	<div class="tr tooltip-paragraph-first-fold">There is no limit on the number of mails, minimum number of 1 mail.</div>
	<div class="tooltip-paragraph-first-fold">
		<span class="tr">For purchases of 100 or more, mail is logged into</span>
		<a href='#' onclick=BrowserAutomationStudio_OpenUrl('https://notletters.com/user/orders')>
			<span class="tr">Orders</span>
		</a>
	</div>
	<div class="tr tooltip-paragraph-first-fold">The “type_email” field is specified depending on the mail type.</div>
</div>
<%= _.template($('#back').html())({action:"executeandadd", visible:true}) %>
<%= "<s" + "cript>" %>
		$(document).ready(function(){
			let nlOkButton = document.getElementById('ok')
			nlOkButton.style.backgroundColor = '#fbad46'
			nlOkButton.style.borderColor = '#352b1e'
			let nlVariables = document.querySelectorAll(".variable-input");
			for (let i = 0; i < nlVariables.length; i++) {
				nlVariables[i].style.color = "#fbad46";
			}
			});
<%= "</" + "script>" %>
