_NOTLETTERSAPI.tools = {
	cleanObject: function (object, props) {
		if (!object || !Object.keys(object).length) return {}
		props = props || Object.keys(object)
		var _ctxt = {}
		Object.keys(object).forEach(function (prop) {
			if (
				object.hasOwnProperty(prop) &&
				object[prop] &&
				~props.indexOf(prop)
			) {
				_ctxt[prop] = object[prop]
			}
		})
		return _ctxt
	},
	typeValid: function (el, type) {
		switch (type) {
			case 'string':
				return Object.prototype.toString.call(el) === '[object String]'
			case 'array':
				return Object.prototype.toString.call(el) === '[object Array]'
			case 'number':
				return typeof el === 'number'
			case 'object':
				return Object.prototype.toString.call(el) === '[object Object]'
			default:
				return false
		}
	},
	JSONload: function (string) {
		_ctxt = null
		try {
			_ctxt = JSON.parse(string)
		} catch (e) {}
		return _ctxt
	},
	reduceString: function (string) {
		return string ? string.toString().trim() : ''
	},
	errorsHandler: function (code, text) {
		code = _NOTLETTERSAPI.tools.reduceString(code)

		var errorObj = _NOTLETTERSAPI.errors.hasOwnProperty(code)
			? _NOTLETTERSAPI.errors[code]
			: _NOTLETTERSAPI.errors['unknown']

		var msg = errorObj[_K] || errorObj['ru']
		msg = msg + (text ? ' | ' + text : '')

		_NOTLETTERSAPI.tools.log('●' + ' ' + msg)

		msg = 'NOTLETTERS API: ' + msg

		if (errorObj.action === 'fail') {
			http_client_set_fail_on_error(true)
			_switch_http_client_main()
			fail(msg, Boolean(errorObj.stop))
		}
		if (errorObj.action === 'die') {
			die(msg, Boolean(errorObj.instantly))
		}

		return
	},
	setErrors: function (ctxt) {
		if (!ctxt.err) return
		;(_NOTLETTERSAPI.tools.typeValid(ctxt.err, 'array')
			? ctxt.err
			: ctxt.err.split(',')
		).forEach(function (el) {
			_NOTLETTERSAPI.errors[el] = _NOTLETTERSAPI.errors[el] || {}
			_NOTLETTERSAPI.errors[el].action = ctxt.errType
			_NOTLETTERSAPI.errors[el].stop = Boolean(ctxt.stop)
			_NOTLETTERSAPI.errors[el].instantly = Boolean(ctxt.instantly)
		})
	},
	log: function (ruText, enText) {
		if (_NOTLETTERSAPI.debug) {
			enText = enText || ruText
			var msg = _K === 'ru' ? ruText : enText
			msg = _NOTLETTERSAPI.tools.typeValid(msg, 'array') ? msg.join(' | ') : msg
			_info('[NOTLETTERS API | DEBUG] ' + msg)
		}
	},
	warn: function (ruText, enText) {
		enText = enText || ruText
		var msg = _K === 'ru' ? ruText : enText
		msg = _NOTLETTERSAPI.tools.typeValid(msg, 'array') ? msg.join(' | ') : msg
		log('[NOTLETTERS API | WARNING] ' + msg)
	},
	sleep: function () {
		var sleepTime = Object(_arguments())['time'] || 1000
		_NOTLETTERSAPI.tools.log('● Пауза ' + sleepTime, '● Pause ' + sleepTime)
		sleep(sleepTime)!
	},
	jsonToBase64Array: function (object, props) {
		if (!object || !Object.keys(object).length) return {}
		props = props || Object.keys(object)
		var _result = []
		Object.keys(object).forEach(function (prop) {
			if (
				object.hasOwnProperty(prop) &&
				object[prop] &&
				~props.indexOf(prop)
			) {
				_result.push(prop);
				_result.push("base64://" + object[prop]);
			}
		})
		return _result
	}
}
