_NOTLETTERSAPI.request = {
	make: function () {
		var ctxt = _arguments()

		var params = ctxt.params || {}
		var path = ctxt.path || ''
		var baseUrl = _NOTLETTERSAPI.baseUrl
		var version = ctxt.version || 'v1'

		var url = baseUrl + '/' + version + path
		if (Object.keys(params).length) {
			url += '?' + _NOTLETTERSAPI.request.serialize(params)
		}

		var timeout = Number(ctxt.timeout) || 10000
		var maxTime = (Number(ctxt.maxTime) || 60000) + Date.now()
		var interval = Number(ctxt.interval) || 2000

		var method = ctxt.method || 'GET'
		var dataJ = ctxt.dataJ ? JSON.stringify(ctxt.dataJ) : null
		var files = ctxt.files || null


		if (!_NOTLETTERSAPI.token) {
			_NOTLETTERSAPI.tools.errorsHandler('Unauthorized')
			return
		}

		var response = null

		_do(function () {
			var timeLeft = maxTime - Date.now()
			if (timeLeft - interval < 0) _break()

			_if(_iterator() % 2 === 0, function () {
				_call_function(_NOTLETTERSAPI.tools.sleep, { time: interval })!
					_next('function')
			})!

				_NOTLETTERSAPI.tools.log(
					'● Осталось времени: ' + timeLeft,
					'● Time left: ' + timeLeft
				)

			_call_function(_NOTLETTERSAPI.request.send, {
				url: url,
				timeout: timeout,
				maxTime: timeLeft,
				interval: interval,
				method: method,
				dataJ: dataJ,
				files: files
			})!

			var candidate = _result_function()

			if (!candidate || !_NOTLETTERSAPI.tools.typeValid(candidate, 'object')) {
				_next('function')
			}

			var resValid =
				candidate.status === 'ok'


			if ((resValid || candidate.status === undefined) && !candidate.errors) {
				response = candidate
				_break()
			}

			var errorCode =
				candidate.errors ? candidate.errors[0] : 'MALFORMED_RESPONSE'

			if (errorCode === 'MALFORMED_RESPONSE') {
				_NOTLETTERSAPI.tools.errorsHandler(errorCode)
			} else {
				_NOTLETTERSAPI.tools.errorsHandler(errorCode, errorCode)
			}

		})!

		_function_return(response)
	},
	send: function () {
		var ctxt = _arguments()

		var url = _NOTLETTERSAPI.tools.reduceString(ctxt.url)

		var timeout = Number(ctxt.timeout) || 10000
		var maxTime = (Number(ctxt.maxTime) || 60000) + Date.now()
		var interval = Number(ctxt.interval) || 2000

		var headers =
			'User-Agent: NotLetters API BAS\r\nAccept: application/json\r\n' +
			'Accept-Encoding: gzip, deflate\r\nConnection: keep-alive'
		if (_NOTLETTERSAPI.token) {
			headers += '\r\nAuthorization: Bearer ' + _NOTLETTERSAPI.token
		}

		var method = ctxt.method
		var dataJ = ctxt.dataJ
		var files = ctxt.files

		var response = null
		var responseTime = null

		_switch_http_client_internal()
		http_client_set_fail_on_error(false)

		if (_NOTLETTERSAPI.use_proxy) {
			var proxy = proxy_parse(_NOTLETTERSAPI.proxy);
			if (_NOTLETTERSAPI.proxy_type !== "auto"){
				proxy["IsHttp"] = _NOTLETTERSAPI.proxy_type === "http";
			}

			http_client_set_proxy(proxy["server"], proxy["Port"], proxy["IsHttp"], proxy["name"], proxy["password"])
		}

		_do(function () {
			var timeLeft = maxTime - Date.now()
			if (timeLeft - interval < 0) _break()

			_if(_iterator() > 1, function () {
				_call_function(_NOTLETTERSAPI.tools.sleep, { time: interval })!
			})!

				_call(function () {
					_on_fail(function () {
						VAR_LAST_ERROR = _result()
						VAR_ERROR_ID = ScriptWorker.GetCurrentAction()
						VAR_WAS_ERROR = false
						_break(1, true)
					})

					CYCLES.Current().RemoveLabel('function')

					var requestTimeout =
						timeLeft < timeout
							? timeLeft
							: timeout < 60000
								? timeout
								: 60000

					_NOTLETTERSAPI.tools.log('↑ Запрос: ' + url, '↑ Request: ' + url)
					_NOTLETTERSAPI.tools.log(
						'● Время ожидания ответа: ' + requestTimeout,
						'● Response timeout: ' + requestTimeout
					)

					responseTime = Date.now()
					general_timeout_next(requestTimeout)
					if (method === 'GET' || method === 'DELETE') {
						http_client_get2(url, {
							method: method,
							headers: headers
						})!
					} else if (method === 'POST' || method === 'PUT') {
						if (files) {
							http_client_post(url, files, {
								'content-type': 'multipart',
								encoding: 'UTF-8',
								method: method,
								headers: headers
							})!
						} else {
							http_client_post(url, dataJ ? ['data', dataJ] : null, {
								'content-type': 'application/json',
								encoding: 'UTF-8',
								method: method,
								headers: headers
							})!
						}
					}
				}, null)!

			if (http_client_was_error() || VAR_WAS_ERROR) {
				_NOTLETTERSAPI.tools.errorsHandler(
					VAR_WAS_ERROR ? 'REQUEST_TIMEOUT' : 'REQUEST_FAILED'
				)
			} else {
				responseTime = Date.now() - responseTime
				var statusCode = http_client_status()
				var contentType = http_client_header('Content-Type')
				var body = http_client_content('utf-8')

				_NOTLETTERSAPI.tools.log(
					[
						'↓ Время ответа: ' + responseTime,
						'Cтатус: ' + statusCode,
						'Тип содержимого: ' + contentType
					],
					[
						'↓ Response time: ' + responseTime,
						'Status: ' + statusCode,
						'Content-type: ' + contentType
					]
				)
				_NOTLETTERSAPI.tools.log('↓ Ответ: ' + body, '↓ Response: ' + body)

				var resValid =
					statusCode === 200 &&
					contentType.indexOf('application/json') === 0 &&
					body

				var candidate = resValid ? _NOTLETTERSAPI.tools.JSONload(body) : null

				if (candidate) {
					response = candidate
					_break()
				}

				var resNotValid =
					statusCode !== 200 &&
					contentType.indexOf('application/json') === 0 &&
					body
				var errorMsg = resNotValid ? _NOTLETTERSAPI.tools.JSONload(body) : null

				if (statusCode === 401) {
					if (errorMsg && errorMsg.error) {
						_NOTLETTERSAPI.tools.errorsHandler(errorMsg.error)
					} else {
						_NOTLETTERSAPI.tools.errorsHandler('UNKNOWN_ERROR')
					}
				} else if (statusCode === 402) {
					if (errorMsg && errorMsg.error) {
						_NOTLETTERSAPI.tools.errorsHandler(errorMsg.error)
					} else {
						_NOTLETTERSAPI.tools.errorsHandler('UNKNOWN_ERROR')
					}
				} else if (statusCode === 404) {
					if (errorMsg && errorMsg.error) {
						_NOTLETTERSAPI.tools.errorsHandler(errorMsg.error)
					} else {
						_NOTLETTERSAPI.tools.errorsHandler('UNKNOWN_ERROR')
					}
				} else if (statusCode === 429) {
					_NOTLETTERSAPI.tools.errorsHandler('RATE_LIMIT_EXCEEDED')
				} else if (statusCode <= 400) {
					if (errorMsg && errorMsg.error) {
						_NOTLETTERSAPI.tools.errorsHandler(errorMsg.error)
					} else {
						_NOTLETTERSAPI.tools.errorsHandler('bad request')
					}
				} else if (statusCode <= 500) {
					if (errorMsg && errorMsg.error) {
						_NOTLETTERSAPI.tools.errorsHandler(errorMsg.error)
					} else {
						_NOTLETTERSAPI.tools.errorsHandler('SYSTEM_ERROR')
					}
				} else {
					_NOTLETTERSAPI.tools.errorsHandler('MALFORMED_RESPONSE')
				}
			}
		})!

		http_client_set_proxy()
		http_client_set_fail_on_error(true)
		_switch_http_client_main()

		_function_return(response)
	},
	serialize: function (object) {
		var _ctxt = []
		for (var prop in object)
			if (object.hasOwnProperty(prop)) {
				var value = object[prop];
				if (Array.isArray(value)) {
                // Если значение — массив, добавляем каждый элемент с тем же ключом
                value.forEach(function (item) {
                    _ctxt.push(
                        encodeURIComponent(prop) +
                        '=' +
                        encodeURIComponent(item).replace(/%20/g, '+') // Изменяем пробелы
                    );
                });
            } else {
                // Если значение — не массив, добавляем его как обычно
                _ctxt.push(
                    encodeURIComponent(prop) +
                    '=' +
                    encodeURIComponent(value).replace(/%20/g, '+') // Изменяем пробелы
                );
            }
			}
		return _ctxt.join('&')
	}
}
