_NOTLETTERSAPI = {
	baseUrl: 'https://api.notletters.com',
	version: 'v1',
	token: '',
	debug: false,
	use_proxy: false,
	proxy: '',
	proxy_type: 'http',

	setDefaultSetting: function (ctxt) {
		if (!ctxt || !Object.keys(ctxt).length) return

		_NOTLETTERSAPI.baseUrl = 'https://' + ctxt.baseUrl
		_NOTLETTERSAPI.version = ctxt.version

		_NOTLETTERSAPI.debug = Boolean(ctxt.debug)

		_NOTLETTERSAPI.token = ctxt.token

		_NOTLETTERSAPI.use_proxy = Boolean(ctxt.use_proxy)
		_NOTLETTERSAPI.proxy = ctxt.proxy
		_NOTLETTERSAPI.proxy_type = ctxt.proxy_type
		
		if (ctxt.failErrors) {
			_NOTLETTERSAPI.tools.setErrors({
				err: ctxt.failErrors,
				errType: 'fail',
				stop: Boolean(ctxt.failStop)
			})
		}
		if (ctxt.dieErrors) {
			_NOTLETTERSAPI.tools.setErrors({
				err: ctxt.dieErrors,
				errType: 'die',
				instantly: Boolean(ctxt.dieInstantly)
			})
		}
		if (ctxt.ignoreErrors) _NOTLETTERSAPI.tools.setErrors({ err: ctxt.ignoreErrors })

		return
	},
	get_letters: function () {
		var ctxt = _arguments()

		var dataJ = _NOTLETTERSAPI.tools.cleanObject(ctxt, [
			'email',
			'password',
			'search',
			'star',
		])

		var filters = {}

		if (dataJ.search) {
		  filters.search = dataJ.search
		}
		if (dataJ.star === 'true' || dataJ.star === 'false') {
		  filters.star = dataJ.star === 'true'

		}
		if (Object.keys(filters).length > 0) {
		  dataJ.filters = filters
		}

		delete dataJ.search
		delete dataJ.star

		var timeout = Number(ctxt.timeout) || 5000
		var interval = Number(ctxt.interval) || 3000
		var maxTime = Number(ctxt.maxTime) || 60000

		var path = '/letters'

		_call_function(_NOTLETTERSAPI.request.make, {
			path: path,
			timeout: timeout,
			interval: interval,
			maxTime: maxTime,
			dataJ: dataJ,
			method: 'POST'
		})!

		_function_return(_result_function())
	},
	change_password: function () {
		var ctxt = _arguments()

		var dataJ = _NOTLETTERSAPI.tools.cleanObject(ctxt, [
			'email',
			'new_password',
			'old_password',
		])
		
		var timeout = Number(ctxt.timeout) || 5000
		var interval = Number(ctxt.interval) || 3000
		var maxTime = Number(ctxt.maxTime) || 60000

		var path = '/change-password'

		_call_function(_NOTLETTERSAPI.request.make, {
			path: path,
			timeout: timeout,
			interval: interval,
			maxTime: maxTime,
			dataJ: dataJ,
			method: 'POST'
		})!

		_function_return(_result_function())
	},
	buy_emails: function () {
		var ctxt = _arguments()

		var dataJ = _NOTLETTERSAPI.tools.cleanObject(ctxt, [
			'count',
			'type_email',
		])
		
		var timeout = Number(ctxt.timeout) || 5000
		var interval = Number(ctxt.interval) || 3000
		var maxTime = Number(ctxt.maxTime) || 60000

		var path = '/buy-emails'

		_call_function(_NOTLETTERSAPI.request.make, {
			path: path,
			timeout: timeout,
			interval: interval,
			maxTime: maxTime,
			dataJ: dataJ,
			method: 'POST'
		})!

		_function_return(_result_function())
	},
	get_balance: function () {
		var ctxt = _arguments()
		
		var timeout = Number(ctxt.timeout) || 5000
		var interval = Number(ctxt.interval) || 3000
		var maxTime = Number(ctxt.maxTime) || 60000

		var path = '/me'

		_call_function(_NOTLETTERSAPI.request.make, {
			path: path,
			timeout: timeout,
			interval: interval,
			maxTime: maxTime,
			method: 'GET'
		})!

		_function_return(_result_function())
	}
}

